package com.agilex.healthcare.directscheduling.domain.facility;

import java.util.Collection;
import java.util.HashSet;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.directscheduling.domain.Namespace;

@XmlRootElement(name = "facilityClinic", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DSFacilityClinic {

	private String stopCode ; 
	private Collection< DSFacilityProvider > providers ;
	
	public DSFacilityClinic( ) { 
		
		providers = new HashSet< DSFacilityProvider >( ) ;  
	}
	
	@XmlElement
	public String getStopCode() {
		return stopCode;
	}
	public void setStopCode(String stopCode) {
		this.stopCode = stopCode;
	}
	
	@XmlElement( name = "providerList" )
	public Collection< DSFacilityProvider > getProviders() {
		return providers;
	}
	public void setProviders(Collection< DSFacilityProvider > providers) {
		this.providers = providers;
	} 
	
	public String toString( ) { 
		
		StringBuffer sb = new StringBuffer( ) ; 
		
		sb.append( "stopCode=" ).append( stopCode ).append( "\r\n" ) ; 
		sb.append( "providers=" ).append( providers ) ; 
		
		return( sb.toString( ) ) ;
	}
	
}
